clear all
close all
c_const=299792.458; % km/s
b=importdata('./Dipole spectrum.txt');
c=load('Reflection_lorentzian_fit.mat');
addpath([docroot '/techdoc/creating_plots/examples'])
lambda=b.data(:,1)-40; % nm  offset 40nm
plas_lambda_index=[ 62 63];
frequency=c_const./lambda; %THz
freq_D2=c_const./852;

a=load('window.mat');
load('plot_data_MM_process_coupledFM_20150209T121517');


R=zeros(size(b.data,1),size(b.data,2)-1);
lambda_p=[668 707 740 770 795 820 858 898 943 973].';
frequency_p=c_const./lambda_p;
R_0=[0.884 0.876 0.707 0.685 0.513 0.303 0.366 0.702 0.897 0.972 0.077];
slit_size=[163 174 183 192 201 210 219 228 237 246];
order_magnitude=1e6;
yscale=[1 2 1 1 1,...
        1 1 1 4 1 2]*order_magnitude;
for i=1:10
    R(:,i)=b.data(:,i+1)./100;
    col_order(i,:)=[i/10 1-i/10 1];
    lambda_ptxt{i}=['\lambda_{p}=' num2str(lambda_p(i)) 'nm'];
    freq(1:size_f(i),i)=plot_data(i,1:size_f(i),1);
    deltax=freq(2,i)-freq(1,i);
    ux=triu(ones(size_f(i)));
    x_data(1:size_f(i),i)=plot_data(i,1:size_f(i),2)*yscale(i);
    y_data(1:size_f(i),i)=plot_data(i,1:size_f(i),3)*yscale(i);
    x_theory(1:size_f(i),i)=plot_data(i,1:size_f(i),4)*yscale(i);
    y_theory(1:size_f(i),i)=plot_data(i,1:size_f(i),5)*yscale(i);
    x_dint(1:size_f(i),i)=(x_data(1:size_f(i),i).'*ux*deltax).';
    y_dint(1:size_f(i),i)=(y_data(1:size_f(i),i).'*ux*deltax).';
    x_tint(1:size_f(i),i)=(x_theory(1:size_f(i),i).'*ux*deltax).';
    y_tint(1:size_f(i),i)=(y_theory(1:size_f(i),i).'*ux*deltax).';
   
end
Z_window=a.fit(1,2)*exp(1i*a.fit(1,3));
w0_window=a.fit(1,4);
Gamma_window=a.fit(1,1);
Z=fit(:,2).*exp(1i*fit(:,3));
w0=fit(:,4);
Gamma=fit(:,1);
unit_type='centimeters';
% f_pos=[2 2 15.2*0.75 22*0.75]; % f_pos=[2 2 37 22];
% f_pos=[2 2 8.8 12.7] ; % single column width
f_pos=[2 2 18.0 18]; % double column width
left=0.06;bottom=0.04;width=0.385;height=0.14;gap=0.03;
bgcolor=[1 1 1];fgcolor=[0 0 0];
% a_pos=[left+width+gap bottom width height; left+width+gap bottom+height width height; ...
%        left bottom width height; left bottom+height width height; ...
%        left+width+gap bottom+2*height+gap width height; left+width+gap bottom+3*height+gap width height; ...
%        left bottom+2*height+gap width height; left bottom+3*height+gap width height; ...
%        left+width+gap bottom+4*height+2*gap width height; left+width+gap bottom+5*height+2*+gap width height; ...
%        left bottom+4*height+2*+gap width height; left bottom+5*height+2*gap width height];
a_pos=[left+width+gap bottom width height; left bottom width height; ...
       left+width+gap bottom+height width height; left bottom+height width height;...
       left+width+gap bottom+2*height width height; left bottom+2*height width height;...
       left+width+gap bottom+3*height width height; left bottom+3*height width height;...
       left+width+gap bottom+4*height width height; left bottom+4*height width height;...
       left+width+gap bottom+5*height width height; left bottom+5*height width height];

% a_pos=[0.0 0.0 1 0.5; 0 0.5 1 0.5];
y1_tick_mode={'auto' ;'auto' ;'auto' ;'auto'; 'auto' ;'auto'};
x1_tick_mode={'manual' ;'auto' ;'manual' ;'manual'; 'manual' ;'auto'};
y1_axis_location={'left';'left';'left';'left';'left';'left'};
x1_axis_location={'top';'bottom';'top';'top';'top';'top'};
y2_tick_mode={'auto' ;'auto' ;'auto' ;'auto'; 'auto' ;'auto'};
x2_tick_mode={'auto' ;'manual' ;'manual' ;'manual'; 'manual' ;'auto'};
y2_axis_location={'right';'right';'right';'right'; 'right';'right'};
x2_axis_location={'bottom';'bottom';'bottom';'bottom';'bottom';'top'};
x1str='Frequency (THz)';
x2str='Detuning (MHz)';
xRstr='Plasmonic Frequency (THz)';
% y1str='Reflection';
y1str='R';
y2str={'\Delta R 10^{-6}'};
yRstr={'Reflection' ;'@ 852 nm'};
style={'r-' 'b--' ,'b-' 'k--'};
x1limit=[260 540];
x2limit=[-80 80];
y1limit=[0.25 0.7];
yRlimit=[0.25 1.1];
y2limit=[-8e-1 8e-1];
line_width=3;
line_width2=2;
Rmarkersize=8;
silver=[192 192 192]/255;

sq_l_from_rgt=10;
sq_b_from_top=0.2;
sq_b_from_bot=0.04;
scaley=4.4e-4;
% manual_h_offset=[0 0.02 0 0 0.0 0.0 0.07 0 0.06 0 0];
manual_h_offset=[0 0.0 0 0 0.0 0.0 0.0 0 0.0 0 0];

sub_label={'';'(k)';...
          '(e)';'(j)';...
          '(d)';'(i)';...
          '(c)';'(h)';...
          '(b)';'(g)';...
          '(a)';'(f)'};
s_lbl_xpos=0.03;s_lbl_ypos=0.35;
p_lbl_xpos=s_lbl_xpos;
p_lbl_ypos=s_lbl_ypos-0.22;

arrow_size=2;arrow_width=0.4;
arrowy_off=0.02;arrowhead_size=2;
text_arrow_offset=0.016;
text_font=8;
font_size=12;
d2_line_x1=[freq_D2-2 freq_D2+2 ];
d2_line_x=[d2_line_x1,...
           ;freq_D2-2 freq_D2+2];
d2_line_width=2;
half_l=0.05;

bu_line_x=[d2_line_x(2,:);
           x1limit];

scale_text_xpos=60;
scale_text_ypos=0.55;
subscript_offset=2;
g(1)=figure('Units',unit_type,'Position',f_pos);

lorentz=@(fit_param,x)(1-fit_param(1)./((x-fit_param(2)).^2+fit_param(3).^2)-fit_param(4));

ii=6;
for jj=[9 7 6 5 2]

ax(1)=axes('FontSize',font_size);
if jj==9
    plot(ax(1),frequency,R(:,jj),style{3},...
    frequency,lorentz(c.fit_out(:,jj),frequency),style{4},...
    'LineWidth',line_width)
else
     plot(ax(1),frequency,R(:,jj),style{3},...
    'LineWidth',line_width)
end
set(ax(1),'XTickLabelmode',x1_tick_mode{ii},...
    'YTickLabelMode',y1_tick_mode{ii},...
    'XColor',fgcolor,'Ycolor',fgcolor,'Color',bgcolor,...
    'Position',a_pos(2*ii,:),'YAxisLocation',y1_axis_location{ii},...
    'XAxisLocation',x1_axis_location{ii});
xlim(x1limit);
ylim(y1limit);
if find(ii==[6 2])
    xlabel(x1str);
end
hyl1=ylabel(y1str);
y1pos=get(hyl1,'position');
% if rem(ii,2)
%     y1pos(1)=y1pos(1)+5;
% else
%     y1pos(1)=y1pos(1)-5;
% end
% set(hyl1,'position',y1pos)

posf=get(g(1),'Position');
posa=get(ax(1),'Position');
da=daspect;

%% square
h_w_scale=posf(4)*posa(4)/posf(3)/posa(3);
sq_h=2.2*slit_size(jj)*scaley;
sq_w=sq_h*da(1)*h_w_scale;
sq_l=x1limit(2)-sq_l_from_rgt-sq_w;
% sq_b=y1limit(2)-sq_b_from_top-sq_h+manual_h_offset(jj);
sq_b=y1limit(1)+sq_b_from_bot+manual_h_offset(jj);
sq=rectangle('Position',[sq_l sq_b sq_w sq_h],'LineStyle','--',...
              'FaceColor',silver);
%% slit
rect_h=70*scaley;
rect_w=sq_w/2.2;
rect_l=sq_l+(sq_w-rect_w)/2;rect_b=sq_b+(sq_h-rect_h)/2;

rect_position=[rect_l rect_b rect_w rect_h];
rect_line_width=0.5;
h=rectangle('Position',rect_position,'LineWidth',rect_line_width,...
            'FaceColor',bgcolor);

%% slit arrow
h_arrow_pos=[rect_l rect_b-arrowy_off; rect_l+rect_w rect_b-arrowy_off];

[h_arrowx,h_arrowy] = dsxy2figxy(gca, h_arrow_pos(:,1), h_arrow_pos(:,2));
% h_text_x=mean(h_arrowx);h_text_y=mean(h_arrowy)-text_arrow_offset;
h_text_x=h_arrowx(1)-text_arrow_offset;h_text_y=h_arrowy(1)-text_arrow_offset;
h_text_w=diff(h_arrowx)+2*text_arrow_offset;h_text_h=0.02;
har = annotation('doublearrow',h_arrowx,h_arrowy);
set(har,'Head1Width',arrow_size,'Head2Width',arrow_size,...
        'LineWidth',arrow_width,'Head1Style','vback1','Head1Style','vback1',...
        'Head1Length',arrowhead_size,'Head2Length',arrowhead_size);
htxt = annotation('textbox',[h_text_x h_text_y h_text_w h_text_h],...
                  'String',[num2str(slit_size(jj)) 'nm'],'Fontsize',text_font,...
                  'LineStyle', 'none',...
                  'HorizontalAlignment', 'center');

%% square arrow
h2_arrow_pos=[sq_l sq_b+sq_h-arrowy_off; sq_l+sq_w sq_b+sq_h-arrowy_off];

[h2_arrowx,h2_arrowy] = dsxy2figxy(gca, h2_arrow_pos(:,1), h2_arrow_pos(:,2));
h2_text_x=h2_arrowx(1)-text_arrow_offset;h2_text_y=h2_arrowy(1)-text_arrow_offset;
h2_text_w=diff(h2_arrowx)+2*text_arrow_offset;h2_text_h=0.02;
har = annotation('doublearrow',h2_arrowx,h2_arrowy);
set(har,'Head1Width',arrow_size,'Head2Width',arrow_size,...
        'LineWidth',arrow_width,'Head1Style','vback1','Head1Style','vback1',...
        'Head1Length',arrowhead_size,'Head2Length',arrowhead_size);
h2txt = annotation('textbox',[h2_text_x h2_text_y h2_text_w h2_text_h],...
             'String',[num2str(round(slit_size(jj)*2.2)) 'nm'],'Fontsize',text_font,...
             'LineStyle', 'none',...
             'HorizontalAlignment', 'center');

              
%% blow up lines              
d2_line_y1=[mean(R(plas_lambda_index,jj))+half_l mean(R(plas_lambda_index,jj))+half_l ];
d2_line_y=[d2_line_y1,...
           ;mean(R(plas_lambda_index,jj))-half_l mean(R(plas_lambda_index,jj))-half_l];                
line(d2_line_x,d2_line_y,'LineWidth',d2_line_width,'Color','r')

bu_line_y=[d2_line_y(2,:); y1limit(1) y1limit(1)];
% line(bu_line_x,bu_line_y,'LineWidth',1,'LineStyle','--','Color','k')
%% figure sublabel
text(s_lbl_xpos,s_lbl_ypos,sub_label{2*ii-1},'Units','Normalized');

%% plasmonic resonance 
text(p_lbl_xpos,p_lbl_ypos,...
    ['\lambda_p = ' num2str(lambda_p(jj)) 'nm'],...
    'Units','Normalized');

%% Second axes 
ax(2)=axes('FontSize',font_size);

plot(ax(2),freq(1:size_f(i),jj),y_dint(1:size_f(i),jj),style{1},...
           freq(1:size_f(i),jj),y_tint(1:size_f(i),jj),style{2},...
           'LineWidth',line_width2);
set(ax(2),'XTickLabelmode',x2_tick_mode{ii},...
    'YTickLabelMode',y2_tick_mode{ii},...
    'XColor',fgcolor,'Ycolor',fgcolor,'Color',bgcolor,...
    'Position',a_pos(2*ii-1,:),'YAxisLocation',y2_axis_location{ii},...
    'XAxisLocation',x2_axis_location{ii});
       
xlim(x2limit);
ylim(y2limit);
hyl2=ylabel(y2str);
y2pos=get(hyl2,'position');
y2pos(1)=x2limit(1)-(diff(x2limit))*(x1limit(1)-y1pos(1))./(diff(x1limit));
if rem(ii,2)
    y2pos(1)=y2pos(1)-subscript_offset;
    Rpos=y2pos;
end
% set(hyl2,'position',y2pos); %%% Align ylabels

if find(ii==[6 1])
    xlabel(x2str);
end
if yscale(jj)~=order_magnitude
    text(scale_text_xpos,scale_text_ypos,...
    [' ' num2str(yscale(jj)/order_magnitude)],...
    'FontSize',font_size);
    
end
%% figure sublabel
text(s_lbl_xpos,s_lbl_ypos,sub_label{2*ii},'Units','Normalized');

filename{jj}=['D_' num2str(jj) '_annot.pdf'];
% saveTightFigure(g(jj),filename{jj});
% print(g(jj),'-dpdf',filename{jj});
ii=ii-1;
end

%%% window
jj=11;
ii=1;
% g(jj)=figure;
% ax(1)=axes('FontSize',font_size);
% % plot(ax(1),frequency_p,R_0(1:10),style{4},'LineWidth',line_width,...
% %             'MarkerSize',Rmarkersize)
% plot(ax(1),frequency,0.04);
% set(ax(1),'XTickLabelmode',x1_tick_mode{ii},...
%     'YTickLabelMode',y1_tick_mode{ii},...
%     'XColor',fgcolor,'Ycolor',fgcolor,'Color',bgcolor,...
%     'Position',a_pos(2*ii,:),'yaxisLocation',y1_axis_location{ii},...
%     'XAxisLocation',x1_axis_location{ii});
% xlim(x1limit);
% ylim(yRlimit);
% xlabel(xRstr);
% ylabel(yRstr);
ax(2)=axes('FontSize',font_size);

deltax=a.f(2)-a.f(1);
ux=triu(ones(length(a.f)));
Yint=a.LockYfiltrotate.'*ux*deltax*yscale(11);
Xint=a.LockXfiltrotate.'*ux*deltax*yscale(11);
Xtint=a.SR_x_theoryfilt*ux*deltax*yscale(11);
Ytint=a.SR_y_theoryfilt*ux*deltax*yscale(11);

plot(ax(2),a.f,Yint,style{1},...
           a.f,Ytint,style{2},...
           'LineWidth',line_width2);
set(ax(2),'XTickLabelmode',x2_tick_mode{ii},...
    'YTickLabelMode',y2_tick_mode{ii},...
    'XColor',fgcolor,'Ycolor',fgcolor,'Color',bgcolor,...
    'Position',a_pos(2*ii-1,:),'yaxisLocation',y2_axis_location{ii},...
    'XAxisLocation',x2_axis_location{ii});
xlim(x2limit);
ylim(y2limit);
hlR=ylabel(y2str);
yRpos=get(hlR,'position');yRpos(1)=Rpos(1);
% set(hlR,'position',yRpos); %%% Align ylabels

if strcmp(x2_tick_mode{ii},'auto')
    xlabel(x2str);
end
if yscale(jj)~=order_magnitude
    text(scale_text_xpos,scale_text_ypos,...
    [' ' num2str(yscale(jj)/order_magnitude)],...
    'FontSize',font_size);
end 
%% figure sublabel
text(s_lbl_xpos,s_lbl_ypos,sub_label{2*ii},'Units','Normalized');

% filename=['multi_plot4.pdf'];
% saveLooseFigure(g(1),filename);
% saveTightFigure(g(1),filename);